package examples.jndi;

import javax.naming.*;
import javax.rmi.*;

public class Client { 

     public static void main (String[] args) throws Exception { 

          // Lookup the remote object via JNDI
          Context ctx = new InitialContext(System.getProperties());
          Object remoteObject = ctx.lookup("PKGenerator");

          // Cast the remote object, RMI-IIOP style
          PrimaryKeyGenerator generator = (PrimaryKeyGenerator)
               PortableRemoteObject.narrow(
                    remoteObject, PrimaryKeyGenerator.class);

          // Generate a PK by calling the RMI-IIOP stub
          System.out.println(generator.generate());
     } 
} 